/******************************************************************************\
**
**     COMPANY:	LDW Software
**
**      MODULE:	Chief 
**
** DESCRIPTION:	Chief Restoration Puzzle
**
**      AUTHOR:	Arthur Humphrey, from template of Adrian Francis
**
\******************************************************************************/

#ifndef CHIEF_H
#define CHIEF_H

/******************************************************************************\
** LIBRARY INCLUDES
\******************************************************************************/
#include "ldwImage.h"
#include "PuzzleInterface.h"
#include "../Collectables/CollectableInterface.h"

/******************************************************************************\
** CONSTANT DEFINITIONS
\******************************************************************************/

/******************************************************************************\
** CLASS DEFINITIONS
\******************************************************************************/
class CChief : public IPuzzle
{
	friend class CPuzzle;

private:

	//class structures
	struct SSaveState
	{
	
	};

	//class data

	//class methods
	//setup
	public:		CChief(void);
	public:		void Reset();
	public:		void LoadAssets();
	public:		void ReleaseAssets();
	public:		const int LoadState(const unsigned char *pData);
	public:		const int SaveState(const unsigned char *pData, const int iMaxDataSize) const;

	public:		void Advance(CVillager &Villager, const int iRef);


	// process
	public:		void Refresh();
	public:		void Draw() const;
	public:		void Complete();

	// access
};

/******************************************************************************\
** GLOBAL DECLARATIONS
\******************************************************************************/
extern CChief		Chief;

#endif

/******************************************************************************\
** END OF FILE
\******************************************************************************/